<?php
require_once '../../../4p1c_4cc45t0db._.php';
require_once '../utils/helpers.php';
require_once '../models/Team.php';
require_once '../models/Tournament.php';
require_once '../models/Player.php';

class TeamController
{
    private $teamModel;
    private $tournamentModel;
    private $playerModel;

    public function __construct()
    {
        $db = Database::connect();
        $this->teamModel = new Team($db);
        $this->tournamentModel = new Tournament($db);
        $this->playerModel = new Player($db);
    }

    public function index($tournamentId)
    {
        $teams = $this->teamModel->getTeamsByTournament($tournamentId);
        require '../views/tournaments.php';
    }

    public function show($teamId)
    {
        $players = $this->playerModel->getAllPlayers();
        $team = $this->teamModel->getTeamById($teamId);
        $team['p1'] = $this->playerModel->getPlayerByCode($team['p1']);
        $team['p2'] = $this->playerModel->getPlayerByCode($team['p2']);
        require '../views/team_form.php';
    }
}
