<?php
require_once '../../../4p1c_4cc45t0db._.php';
require_once '../models/Tournament.php';
require_once '../models/Entity.php';
require_once '../models/Game.php';
require_once '../models/Team.php';
require_once '../models/Club.php';
require_once '../models/Ad.php';

class TournamentController
{
    private $tournamentModel;
    private $entityModel;
    private $gameModel;
    private $teamModel;
    private $clubModel;
    private $adModel;

    public function __construct()
    {
        $db = Database::connect();
        $this->tournamentModel = new Tournament($db);
        $this->entityModel = new Entity($db);
        $this->gameModel = new Game($db);
        $this->teamModel = new Team($db);
        $this->clubModel = new Club($db);
        $this->adModel = new Ad($db);
    }

    public function index($entity)
    {
        $tournaments = $this->tournamentModel->getTournamentsByEntity($entity);
        require '../views/tournaments.php';
    }

    public function show($tournamentId)
    {
        $tournament = $this->tournamentModel->getTournamentById($tournamentId);
        $entity = $this->entityModel->getEntityByCode($tournament['entity']);
        $club = isset($tournament['club']) && $tournament['club'] ? $this->clubModel->getClubByCode($tournament['club']) : null;
        $games = $this->gameModel->getGamesByTournament($tournamentId);
        $teams = $this->teamModel->getTeamsByTournament($tournamentId);
        $ads = $this->adModel->getAdByTournament($tournamentId);
        require '../views/tournament.php';
    }
}
