<?php
class Player
{
    private $conn;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function getAllPlayers()
    {
        $sql = "SELECT id, pNombre, pApellido FROM player WHERE state = 1";
        $stmt = $this->conn->prepare($sql);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }

    public function getPlayerById($id)
    {
        $sql = "SELECT * FROM player WHERE id = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc();
    }

    public function getPlayerByCode($code)
    {
        $sql = "SELECT id, pNombre, pApellido FROM player WHERE code = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('s', $code);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function getPlayerCodeById($id)
    {
        $sql = "SELECT code FROM player WHERE id = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc()['code'] ?? null;
    }

    public function getPlayerIdByCode($code)
    {
        $sql = "SELECT id FROM player WHERE code = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('s', $code);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc()['id'] ?? null;
    }

    public function getPlayerPicById($id)
    {
        $sql = "SELECT pic FROM player WHERE id = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc()['pic'] ?? null;
    }
}
