<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($game['desc']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script type="importmap">
        {
            "imports": {
                "three": "../public/js/modules/three.module.js",
                "OrbitControls": "../public/js/modules/OrbitControls.js",
                "FBXLoader": "../public/js/modules/FBXLoader.js",
                "GLTFLoader": "../public/js/modules/GLTFLoader.js",
                "BufferGeometryUtils": "../public/js/modules/BufferGeometryUtils.js",
                "fflate.module": "../public/js/modules/fflate.module.js",
                "NURBSCurve": "../public/js/modules/NURBSCurve.js",
                "NURBSUtils": "../public/js/modules/NURBSUtils.js",
                "RoundedBoxGeometry": "../public/js/modules/RoundedBoxGeometry.js",
                "TextGeometry": "../public/js/modules/TextGeometry.js",
                "FontLoader": "../public/js/modules/FontLoader.js"
            }
        }
    </script>
    <link rel="stylesheet" href="./css/style.css">
    <link rel="stylesheet" href="./css/game.css">
</head>

<body>
    <div class="matchInfo">
        <div class="matchBall iBall"></div>
        <div class="matchDesc"><?= htmlspecialchars($game['desc']) ?></div>
        <div class="matchDate"><?= htmlspecialchars($game['date']) ?></div>
        <div class="matchTournament"></div>
    </div>
    <a href="./tournament.php?id=<?= htmlspecialchars($game['tournament_id'] ?? '') ?>">
        <div class="iClose img closeMatch"></div>
    </a>
    <div class="matchSets notxt">
        <div class="matchTeam">
            <div class="matchNames"><?= htmlspecialchars($game['p1_pApellido'] ?? '') ?> / <?= htmlspecialchars($game['p2_pApellido'] ?? '') ?></div>
            <div class="sets">
                <?= htmlspecialchars($game['s1t1'] ?? '') ?>
                <?= htmlspecialchars($game['s2t1'] ?? '') ?>
                <?= htmlspecialchars($game['s3t1'] ?? '') ?>
            </div>
        </div>
        <div class="matchTeam">
            <div class="matchNames"><?= htmlspecialchars($game['p3_pApellido'] ?? '') ?> / <?= htmlspecialchars($game['p4_pApellido'] ?? '') ?></div>
            <div class="sets">
                <?= htmlspecialchars($game['s1t2'] ?? '') ?>
                <?= htmlspecialchars($game['s2t2'] ?? '') ?>
                <?= htmlspecialchars($game['s3t2'] ?? '') ?>
            </div>
        </div>
    </div>
    <canvas class="img" id="court"></canvas>

    <?php
$sets = [
    intval($game['s1t1'] ?? 0), intval($game['s2t1'] ?? 0), intval($game['s3t1'] ?? 0),
    intval($game['s1t2'] ?? 0), intval($game['s2t2'] ?? 0), intval($game['s3t2'] ?? 0)
];

// Cálculo de sets ganados por cada equipo
$t1Win = count(array_filter(array_slice($sets, 0, 3), fn($s, $i) => $s > $sets[$i + 3], ARRAY_FILTER_USE_BOTH));
$t2Win = count(array_filter(array_slice($sets, 3), fn($s, $i) => $s > $sets[$i], ARRAY_FILTER_USE_BOTH));

// Empate: ambos tienen transparencia 1
$isDraw = $t1Win === $t2Win;

// Transparencia de los equipos basada en los resultados
$T1Transparency = $isDraw || $t1Win > $t2Win ? 1 : 0;
$T2Transparency = $isDraw || $t2Win > $t1Win ? 1 : 0;

$players = [
    [
        'id' => $game['p1'],
        'pic' => $game['p1_pic'],
        'name' => "{$game['p1_pNombre']} {$game['p1_pApellido']}",
        'x' => -800,
        'z' => 250,
        'transparency' => $T1Transparency
    ],
    [
        'id' => $game['p2'],
        'pic' => $game['p2_pic'],
        'name' => "{$game['p2_pNombre']} {$game['p2_pApellido']}",
        'x' => -800,
        'z' => -250,
        'transparency' => $T1Transparency
    ],
    [
        'id' => $game['p3'],
        'pic' => $game['p3_pic'],
        'name' => "{$game['p3_pNombre']} {$game['p3_pApellido']}",
        'x' => 800,
        'z' => 250,
        'transparency' => $T2Transparency
    ],
    [
        'id' => $game['p4'],
        'pic' => $game['p4_pic'],
        'name' => "{$game['p4_pNombre']} {$game['p4_pApellido']}",
        'x' => 800,
        'z' => -250,
        'transparency' => $T2Transparency
    ]
];
    $adsForCreateAds = '';
    foreach ($ads as $ad) {
        $adsForCreateAds .= sprintf(
            '{ imagePath: "../public/img/ads/%s.webp", link: "%s" },',
            htmlspecialchars($ad['ad_name']),
            htmlspecialchars($ad['link'])
        );
    }
    ?>

    <script type="module" src="../public/js/three.js"></script>
    <script type="module">
        import {
            createBillboardCircle,
            createTextGeometry,
            createAds
        } from '../public/js/three.js';

        <?php foreach ($players as $player): ?>
            <?php if ($player['id']): ?>
                createTextGeometry(
                    "<?= addslashes($player['name']) ?>",
                    40, {
                        x: <?= $player['x'] ?>,
                        y: 80,
                        z: <?= $player['z'] ?>
                    },
                    0xffffff,
                    0x000000,
                    true,
                    false
                );

                createBillboardCircle(
                    100, {
                        x: <?= $player['x'] ?>,
                        y: 250,
                        z: <?= $player['z'] ?>
                    },
                    "./img/user/player_<?= $player['pic'] ?>.webp",
                    <?= $player['transparency'] ?>,
                    'player.php?id=<?= $player['id'] ?>'
                );
            <?php endif; ?>
        <?php endforeach; ?>

        <?php if (!empty($adsForCreateAds)): ?>
            createAds([<?= rtrim($adsForCreateAds, ',') ?>]);
        <?php endif; ?>
    </script>
</body>

</html>