<?php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: ../login.php");
    exit;
}

// Incluimos los modelos y el archivo de conexión a la base de datos
require_once '../models/Tournament.php';
require_once '../models/Standings.php';
require_once '../../../4p1c_4cc45t0db._.php';

class StandingsController
{
    private $conn;

    public function __construct()
    {
        // Establecemos la conexión usando la clase `Database`
        $this->conn = Database::connect();
    }

    public function calculateStandings($tournamentId)
    {
        $tournament = new Tournament($this->conn);
        $tournamentCode = $tournament->getTournamentCodeById($tournamentId);

        if (!$tournamentCode) {
            echo json_encode(['status' => 'error', 'message' => 'Código de torneo no encontrado']);
            return;
        }

        $standings = new Standings($this->conn);
        $result = $standings->calculate($tournamentCode);

        echo json_encode($result);
    }
}

// Manejo de la solicitud AJAX
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['id'])) {
    $controller = new StandingsController();
    $controller->calculateStandings($_GET['id']);
}
?>
