<?php
require_once '../../../4p1c_4cc45t0db._.php';
require_once '../utils/helpers.php';
require_once '../models/Tournament.php';
require_once '../models/Game.php';
require_once '../models/Team.php';
require_once '../models/Ad.php';

class TournamentController
{
    private $tournamentModel;
    private $gameModel;
    private $teamModel;
    private $adModel;

    public function __construct()
    {
        $db = Database::connect();
        $this->tournamentModel = new Tournament($db);
        $this->gameModel = new Game($db);
        $this->teamModel = new Team($db);
        $this->adModel = new Ad($db);
    }

    public function index()
    {
        $tournaments = $this->tournamentModel->getAllTournaments();
        require '../views/tournaments.php';
    }

    public function show($tournamentId)
    {
        $tournament = $this->tournamentModel->getTournamentById($tournamentId);
        $games = $this->gameModel->getGamesByTournament($tournamentId);
        $teams = $this->teamModel->getTeamsByTournament($tournamentId);
        $ads = $this->adModel->getAdByTournament($tournamentId);
        require '../views/tournament.php';
    }

    public function store()
    {
        $_POST['entity'] = $_SESSION['entity'];
        $_POST['code'] = generateUUID();
        $this->tournamentModel->createTournament($_POST);
        header('Location: ../public/index.php');
    }

    public function update()
    {
        $this->tournamentModel->updateTournament($_POST);
        header('Location: ../public/tournament.php?id=' . $_POST['id']);
        exit();
    }
}
