<?php
require_once '../../../../4p1c_4cc45t0db._.php';
require_once '../../models/Court.php';
require_once '../../models/Club.php';

// Solo permitimos solicitudes GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Validamos el parámetro club_code
if (!isset($_GET['club_code']) || empty($_GET['club_code'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing club_code parameter']);
    exit;
}

$db = Database::connect();
$courtModel = new Court($db);
$clubModel = new Club($db);

// Obtenemos el clubCode y las canchas asociadas
$clubCode = $clubModel->getClubCodeById($_GET['club_code']);
$courts = $courtModel->getCourtsByClub($clubCode);

// Devolvemos las canchas en formato JSON
header('Content-Type: application/json');
echo json_encode($courts);
