<?php
// Court.php
class Court
{
    private $db;

    public function __construct($database)
    {
        $this->db = $database;
    }

    public function getCourtsByClub($clubCode)
    {
        $query = "SELECT id, name FROM court WHERE club = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param('s', $clubCode);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }

    public function getCourtCodeById($id)
    {
        $query = "SELECT code FROM court WHERE id = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc()['code'] ?? null;
    }

    public function getCourtIdByCode($code)
    {
        $query = "SELECT id FROM court WHERE code = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param('s', $code);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc()['id'] ?? null;
    }
}
