<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}

require '../controllers/TournamentController.php';
require '../views/layouts/navbar.php';


$controller = new TournamentController();

$action = $_GET['action'] ?? 'index';
$id = $_GET['id'] ?? null;

switch ($action) {
    case 'index':
        $controller->index();
        break;
    case 'create':
        require '../views/tournament_form.php';
        break;
    case 'store':
        $controller->store();
        break;
    case 'edit':
        $controller->show($id);
        break;
    case 'update':
        $controller->update();
        break;
    default:
        $controller->index();
        break;
}
