<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

require '../controllers/TournamentController.php';
require '../views/layouts/navbar.php';

$controller = new TournamentController();

$action = $_GET['action'] ?? 'index';
$id = $_GET['id'] ?? null;

switch ($action) {
    case 'create':
        require '../views/tournament_form.php';
        break;
    case 'store':
        $controller->store();
        break;
    case 'update':
        $controller->update();
        break;
    case 'index':
    default:
        if ($id) {
            $controller->show($id);
        } else {
            header("Location: ./index.php");
            exit;
        }
        break;
}
